import random
import openpyxl
from PIL import Image, ImageTk
import tkinter as tk
import os

# Load Excel data
def load_pokemon_data(excel_file, image_folder):
    wb = openpyxl.load_workbook(excel_file)
    sheet = wb.active
    pokemon_data = []
    for row in sheet.iter_rows(min_row=2, values_only=True):
        pokemon_name = row[0]
        image_path = os.path.join(image_folder, f"{pokemon_name}.png")
        if os.path.exists(image_path):
            pokemon_data.append({
                'name': row[0],
                'type1': row[1],
                'type2': row[2],
                'evolution': row[3],
                'image_path': image_path
            })
    return pokemon_data

# Load Pokémon images
def load_image(image_path):
    return Image.open(image_path)

# Create Pokémon generator
def generate_pokemon(pokemon_data):
    selected_pokemon = random.choice(pokemon_data)
    image = load_image(selected_pokemon['image_path'])
    return selected_pokemon, image

# Display Pokémon using Tkinter
def display_pokemon():
    selected_pokemon, image = generate_pokemon(pokemon_data)
    tk_image = ImageTk.PhotoImage(image)
    label_image.config(image=tk_image)
    label_image.image = tk_image
    label_info.config(text=f"Name: {selected_pokemon['name']}\nType1: {selected_pokemon['type1']}\nType2: {selected_pokemon['type2']}\nEvolution: {selected_pokemon['evolution']}")

# Main code
excel_file = 'D:\\aaa\\GAN POKEMON\\archive\\pokemon.xlsx'
image_folder = 'D:\\aaa\\GAN POKEMON\\archive\\images'

pokemon_data = load_pokemon_data(excel_file, image_folder)

# Set up Tkinter window
root = tk.Tk()
root.title("Pokémon Generator")

label_image = tk.Label(root)
label_image.pack()

label_info = tk.Label(root, text="", font=("Helvetica", 16))
label_info.pack()

button_generate = tk.Button(root, text="Generate Pokémon", command=display_pokemon)
button_generate.pack()

# Start the GUI event loop
root.mainloop()
